#include "univ.h"

static void ShiftOut(bytes, shifter)
register bytes;
register long shifter;
{
	PutRemote(bytes);
	do
		PutRemote((char)(shifter>>((--bytes)*8)) );
	while(bytes);
}

static long ShiftIn(bytes)
register bytes;
{
	register long shifter = 0;

	if (GetRemote() != bytes)
		ProtoErr("ShiftIn");
	while(bytes--)
		shifter = (shifter<<8) + (GetRemote()&0xFF);
	return shifter;
}

void SendLong(x)  long  x;		{ ShiftOut( P_LONG,  (long) x ); }
void SendShort(x) short x;		{ ShiftOut( P_SHORT, (long) x ); }
void SendUChar(x) unsigned char x;	{ ShiftOut( P_UCHAR, (long) x ); }
long  RcvLong()			{ return (long)  ShiftIn( P_LONG  ); }
short RcvShort()		{ return (short) ShiftIn( P_SHORT ); }
unsigned char RcvUChar()	{ return (unsigned char) ShiftIn( P_UCHAR ); }

void SendString(s)
register char *s;
{
	PutRemote(P_STRING);
	SendUChar(strlen(s));
	while(*s)
		PutRemote(*s++); 
}

char *RcvString(s)
register char *s;
{
	register unsigned char len;

	assertf((long)s);
	if (GetRemote() != (int)P_STRING)
		ProtoErr("RcvString");
	len = RcvUChar();
	while(len-->0)
		*s++ = GetRemote();
	*s = '\0';
	return s;
}

void RcvAllocString(p)
char **p;
{
	register char *s;
	register unsigned char len;

	if (GetRemote() != (int)P_STRING)
		ProtoErr("RcvString");
	len = RcvUChar();
	s = GCAlloc(len+1, p);
	while(len-->0)
		*s++ = GetRemote();
	*s = '\0';
}
